package net.w_horse.excelpojo.xml;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.excel.CellNotFoundException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.annotation.AnnotationTestElementReadTableUseNone;
import test.xml.ColumnInfo;
import test.xml.DataFormatTest;
import test.xml.DateFormatTest;
import test.xml.TableInfo;
import test.xml.XMLTest;
import test.xml.XMLTestElement;


public class ExcelPOJOXmlParserTest extends AbstractTest {
	/**
	 * XML̒`ɂ{Iȓǂݏ̃eXg
	 * ʂ̃^CvE^ɂĂ̊mF
	 *
	 */
	@Test
	public void testReadAndSaveBasic() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveBasic");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<XMLTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		XMLTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}



		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_{.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_{.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML̒`ɂ{Iȓǂݏ̃eXg
	 * ʂ̃^CvE^ɂĂ̊mF
	 * Excel2007`iOOXML`j̊mF
	 *
	 */
	@Test
	public void testReadAndSaveBasic2007() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveBasic");
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xlsx", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<XMLTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		XMLTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}



		bridge.save(
				"./files/template/ParserTest_Template.xlsx",
				"{",
				"./files/export/XMLParserTest_{2007.xlsx",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_{2007.xlsx");
			XSSFWorkbook workBook = new XSSFWorkbook(fileInputStream);
			XSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ鐔l^̃tH[}bgɂ鍷ق̃eXg
	 * Excel2007(OOXML)`̊mF
	 *
	 */
	@Test
	public void testDataFormat2007() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testDataFormat");
		DataFormatTest targetBean = (DataFormatTest) bridge.load("./files/upload/ParserTest.xlsx", "eZ^Cv");

		assertEquals("eZ^Cv 01",1, targetBean.getData1());
		assertEquals("eZ^Cv 02","", targetBean.getData2());
		assertEquals("eZ^Cv 03",-1234, targetBean.getData3());
		assertEquals("eZ^Cv 04",-1234, targetBean.getData4());
		assertEquals("eZ^Cv 05",-1234, targetBean.getData5());
		assertEquals("eZ^Cv 06",-1234, targetBean.getData6());
		assertEquals("eZ^Cv 07",-1234, targetBean.getData7());
		assertEquals("eZ^Cv 08",-1234, targetBean.getData8());
		assertEquals("eZ^Cv 09",-1234, targetBean.getData9());
		assertEquals("eZ^Cv 10",-1234.56, targetBean.getData10(),0.000000000000001);
		assertEquals("eZ^Cv 11",-1234.56, targetBean.getData11(),0.000000000000001);
		assertEquals("eZ^Cv 12",-1234.56, targetBean.getData12(),0.000000000000001);
		assertEquals("eZ^Cv 13",-1234.56, targetBean.getData13(),0.000000000000001);
		assertEquals("eZ^Cv 14",-1234.56, targetBean.getData14(),0.000000000000001);
		assertEquals("eZ^Cv 15",-1234.56, targetBean.getData15(),0.000000000000001);
		assertEquals("eZ^Cv 16",-1234.56, targetBean.getData16(),0.000000000000001);
		assertEquals("eZ^Cv 17",-123456, targetBean.getData17());
		assertEquals("eZ^Cv 18",-123456, targetBean.getData18());
		assertEquals("eZ^Cv 19",-123456, targetBean.getData19());
		assertEquals("eZ^Cv 20",-123456, targetBean.getData20());
		assertEquals("eZ^Cv 21",-123456, targetBean.getData21());
		assertEquals("eZ^Cv 22",-123456.78, targetBean.getData22(),0.000000000000001);
		assertEquals("eZ^Cv 23",-123456.78, targetBean.getData23(),0.000000000000001);
		assertEquals("eZ^Cv 24",-123456.78, targetBean.getData24(),0.000000000000001);
		assertEquals("eZ^Cv 25",-123456.78, targetBean.getData25(),0.000000000000001);
		assertEquals("eZ^Cv 26",-123456.78, targetBean.getData26(),0.000000000000001);
		assertEquals("eZ^Cv 27",-123456, targetBean.getData27());
		assertEquals("eZ^Cv 28",-123456, targetBean.getData28());
		assertEquals("eZ^Cv 29",-123456.78, targetBean.getData29(),0.000000000000001);
		assertEquals("eZ^Cv 30",-123456.78, targetBean.getData30(),0.000000000000001);
		assertEquals("eZ^Cv 31",0.1234, targetBean.getData31(),0.000000000000001);
		assertEquals("eZ^Cv 32",0.1234, targetBean.getData32(),0.000000000000001);
		assertEquals("eZ^Cv 33",2, targetBean.getData33());
		assertEquals("eZ^Cv 34","_t", targetBean.getData34());
		assertEquals("eZ^Cv 35",-1234, targetBean.getData35());
		assertEquals("eZ^Cv 36","2010N623", targetBean.getData36());
		assertEquals("eZ^Cv 37",new BigInteger("-12345678901234500000"), targetBean.getData37());
		assertEquals("eZ^Cv 38",-1.23456789012345E12, targetBean.getData38(),0.000000000000001);
	}

	/**
	 * XML`ɂt^̃tH[}bg̍كeXg
	 * Excel2007(OOXML)`̊mF
	 *
	 */
	@Test
	public void testDateFormat2007() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testDateFormat");
		DateFormatTest targetBean = (DateFormatTest) bridge.load("./files/upload/ParserTest.xlsx", "ttH[}bg");

		assertEquals("ttH[}bg 01", "2010/1/2",targetBean.getDateStr1());
		assertEquals("ttH[}bg 02", "2-Jan-10",targetBean.getDateStr2());
		assertEquals("ttH[}bg 03", "2-Jan",targetBean.getDateStr3());
		assertEquals("ttH[}bg 04", "Jan-10",targetBean.getDateStr4());
		assertEquals("ttH[}bg 05", "9:03 AM",targetBean.getDateStr5());
		assertEquals("ttH[}bg 06", "9:03:04 AM",targetBean.getDateStr6());
		assertEquals("ttH[}bg 07", "9:03",targetBean.getDateStr7());
		assertEquals("ttH[}bg 08", "9:03:04",targetBean.getDateStr8());
		assertEquals("ttH[}bg 09", "2010/1/2 9:03",targetBean.getDateStr9());
		assertEquals("ttH[}bg 10", "1/2/10",targetBean.getDateStr10());
		assertEquals("ttH[}bg 11", "2010N12",targetBean.getDateStr11());
		assertEquals("ttH[}bg 12", "903",targetBean.getDateStr12());
		assertEquals("ttH[}bg 13", "90304b",targetBean.getDateStr13());
		assertEquals("ttH[}bg 14", "03:04",targetBean.getDateStr14());
		assertEquals("ttH[}bg 15", "03:04.0",targetBean.getDateStr15());
		assertEquals("ttH[}bg 16", "2010N1",targetBean.getDateStr16());
		assertEquals("ttH[}bg 17", "12",targetBean.getDateStr17());
		assertEquals("ttH[}bg 18", "H22.1.2",targetBean.getDateStr18());
		assertEquals("ttH[}bg 19", "22N12",targetBean.getDateStr19());
		assertEquals("ttH[}bg 20", "2010/01/02",targetBean.getDateStr20());
		assertEquals("ttH[}bg 21", "2010/01/02",targetBean.getDateStr21());
		assertEquals("ttH[}bg 22", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr22()), 0.0000000001);
		assertEquals("ttH[}bg 23", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr23()), 0.0000000001);
		assertEquals("ttH[}bg 24", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr24()), 0.0000000001);
		assertEquals("ttH[}bg 25", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr25()), 0.0000000001);
		assertEquals("ttH[}bg 26", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr26()), 0.0000000001);
		assertEquals("ttH[}bg 27", "2010/01/02",targetBean.getDateStr27());
		assertEquals("ttH[}bg 28", "2010/01/02",targetBean.getDateStr28());
		assertEquals("ttH[}bg 29", "2010/01/02",targetBean.getDateStr29());
		assertEquals("ttH[}bg 30", "2010/01/02",targetBean.getDateStr30());
		assertEquals("ttH[}bg 31", "2010/01/02",targetBean.getDateStr31());
		assertEquals("ttH[}bg 32", "2010/01/02",targetBean.getDateStr32());
		assertEquals("ttH[}bg 33", "2010/01/02",targetBean.getDateStr33());
		assertEquals("ttH[}bg 34", "2010/01/02",targetBean.getDateStr34());
		assertEquals("ttH[}bg 35", "2010/01/02",targetBean.getDateStr35());
		assertEquals("ttH[}bg 36", "2010/01/02",targetBean.getDateStr36());
		assertEquals("ttH[}bg 37", "2010/01/02",targetBean.getDateStr37());
		assertEquals("ttH[}bg 38", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr38()), 0.0000000001);
		assertEquals("ttH[}bg 39", "2010/01/02",targetBean.getDateStr39());
		assertEquals("ttH[}bg 40", "2010/06/18",targetBean.getDateStr40());

	}

	/**
	 * XML`ɂ鐔l^̃tH[}bgɂ鍷ق̃eXg
	 *
	 */
	@Test
	public void testDataFormat() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testDataFormat");
		DataFormatTest targetBean = (DataFormatTest) bridge.load("./files/upload/ParserTest.xls", "eZ^Cv");

		assertEquals("eZ^Cv 01",1, targetBean.getData1());
		assertEquals("eZ^Cv 02","", targetBean.getData2());
		assertEquals("eZ^Cv 03",-1234, targetBean.getData3());
		assertEquals("eZ^Cv 04",-1234, targetBean.getData4());
		assertEquals("eZ^Cv 05",-1234, targetBean.getData5());
		assertEquals("eZ^Cv 06",-1234, targetBean.getData6());
		assertEquals("eZ^Cv 07",-1234, targetBean.getData7());
		assertEquals("eZ^Cv 08",-1234, targetBean.getData8());
		assertEquals("eZ^Cv 09",-1234, targetBean.getData9());
		assertEquals("eZ^Cv 10",-1234.56, targetBean.getData10(),0.000000000000001);
		assertEquals("eZ^Cv 11",-1234.56, targetBean.getData11(),0.000000000000001);
		assertEquals("eZ^Cv 12",-1234.56, targetBean.getData12(),0.000000000000001);
		assertEquals("eZ^Cv 13",-1234.56, targetBean.getData13(),0.000000000000001);
		assertEquals("eZ^Cv 14",-1234.56, targetBean.getData14(),0.000000000000001);
		assertEquals("eZ^Cv 15",-1234.56, targetBean.getData15(),0.000000000000001);
		assertEquals("eZ^Cv 16",-1234.56, targetBean.getData16(),0.000000000000001);
		assertEquals("eZ^Cv 17",-123456, targetBean.getData17());
		assertEquals("eZ^Cv 18",-123456, targetBean.getData18());
		assertEquals("eZ^Cv 19",-123456, targetBean.getData19());
		assertEquals("eZ^Cv 20",-123456, targetBean.getData20());
		assertEquals("eZ^Cv 21",-123456, targetBean.getData21());
		assertEquals("eZ^Cv 22",-123456.78, targetBean.getData22(),0.000000000000001);
		assertEquals("eZ^Cv 23",-123456.78, targetBean.getData23(),0.000000000000001);
		assertEquals("eZ^Cv 24",-123456.78, targetBean.getData24(),0.000000000000001);
		assertEquals("eZ^Cv 25",-123456.78, targetBean.getData25(),0.000000000000001);
		assertEquals("eZ^Cv 26",-123456.78, targetBean.getData26(),0.000000000000001);
		assertEquals("eZ^Cv 27",-123456, targetBean.getData27());
		assertEquals("eZ^Cv 28",-123456, targetBean.getData28());
		assertEquals("eZ^Cv 29",-123456.78, targetBean.getData29(),0.000000000000001);
		assertEquals("eZ^Cv 30",-123456.78, targetBean.getData30(),0.000000000000001);
		assertEquals("eZ^Cv 31",0.1234, targetBean.getData31(),0.000000000000001);
		assertEquals("eZ^Cv 32",0.1234, targetBean.getData32(),0.000000000000001);
		assertEquals("eZ^Cv 33",2, targetBean.getData33());
		assertEquals("eZ^Cv 34","_t", targetBean.getData34());
		assertEquals("eZ^Cv 35",-1234, targetBean.getData35());
		assertEquals("eZ^Cv 36","2010N623", targetBean.getData36());
		assertEquals("eZ^Cv 37",new BigInteger("-12345678901234500000"), targetBean.getData37());
		assertEquals("eZ^Cv 38",-1.23456789012345E12, targetBean.getData38(),0.000000000000001);
	}

	/**
	 * XML`ɂt^̃tH[}bg̍كeXg
	 *
	 */
	@Test
	public void testDateFormat() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testDateFormat");
		DateFormatTest targetBean = (DateFormatTest) bridge.load("./files/upload/ParserTest.xls", "ttH[}bg");

		assertEquals("ttH[}bg 01", "2010/1/2",targetBean.getDateStr1());
		assertEquals("ttH[}bg 02", "2-Jan-10",targetBean.getDateStr2());
		assertEquals("ttH[}bg 03", "2-Jan",targetBean.getDateStr3());
		assertEquals("ttH[}bg 04", "Jan-10",targetBean.getDateStr4());
		assertEquals("ttH[}bg 05", "9:03 AM",targetBean.getDateStr5());
		assertEquals("ttH[}bg 06", "9:03:04 AM",targetBean.getDateStr6());
		assertEquals("ttH[}bg 07", "9:03",targetBean.getDateStr7());
		assertEquals("ttH[}bg 08", "9:03:04",targetBean.getDateStr8());
		assertEquals("ttH[}bg 09", "2010/1/2 9:03",targetBean.getDateStr9());
		assertEquals("ttH[}bg 10", "1/2/10",targetBean.getDateStr10());
		assertEquals("ttH[}bg 11", "2010N12",targetBean.getDateStr11());
		assertEquals("ttH[}bg 12", "903",targetBean.getDateStr12());
		assertEquals("ttH[}bg 13", "90304b",targetBean.getDateStr13());
		assertEquals("ttH[}bg 14", "03:04",targetBean.getDateStr14());
		assertEquals("ttH[}bg 15", "03:04.0",targetBean.getDateStr15());
		assertEquals("ttH[}bg 16", "2010N1",targetBean.getDateStr16());
		assertEquals("ttH[}bg 17", "12",targetBean.getDateStr17());
		assertEquals("ttH[}bg 18", "H22.1.2",targetBean.getDateStr18());
		assertEquals("ttH[}bg 19", "22N12",targetBean.getDateStr19());
		assertEquals("ttH[}bg 20", "2010/01/02",targetBean.getDateStr20());
		assertEquals("ttH[}bg 21", "2010/01/02",targetBean.getDateStr21());
		assertEquals("ttH[}bg 22", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr22()), 0.0000000001);
		assertEquals("ttH[}bg 23", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr23()), 0.0000000001);
		assertEquals("ttH[}bg 24", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr24()), 0.0000000001);
		assertEquals("ttH[}bg 25", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr25()), 0.0000000001);
		assertEquals("ttH[}bg 26", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr26()), 0.0000000001);
		assertEquals("ttH[}bg 27", "2010/01/02",targetBean.getDateStr27());
		assertEquals("ttH[}bg 28", "2010/01/02",targetBean.getDateStr28());
		assertEquals("ttH[}bg 29", "2010/01/02",targetBean.getDateStr29());
		assertEquals("ttH[}bg 30", "2010/01/02",targetBean.getDateStr30());
		assertEquals("ttH[}bg 31", "2010/01/02",targetBean.getDateStr31());
		assertEquals("ttH[}bg 32", "2010/01/02",targetBean.getDateStr32());
		assertEquals("ttH[}bg 33", "2010/01/02",targetBean.getDateStr33());
		assertEquals("ttH[}bg 34", "2010/01/02",targetBean.getDateStr34());
		assertEquals("ttH[}bg 35", "2010/01/02",targetBean.getDateStr35());
		assertEquals("ttH[}bg 36", "2010/01/02",targetBean.getDateStr36());
		assertEquals("ttH[}bg 37", "2010/01/02",targetBean.getDateStr37());
		assertEquals("ttH[}bg 38", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr38()), 0.0000000001);
		assertEquals("ttH[}bg 39", "2010/01/02",targetBean.getDateStr39());
		assertEquals("ttH[}bg 40", "2010/06/18",targetBean.getDateStr40());

	}
	/**
	 * XML`ɂ\̒ړIȓǂݏ̃eXg
	 * cɃR[hJԂP[X
	 * Listɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly1() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectly1");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\̒ړIȓǂݏ̃eXg
	 * cɃR[hJԂP[X
	 * zɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly2() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectly2");
		XMLTestElement[] arrElm = (XMLTestElement[]) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		XMLTestElement elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"90", "56", "81", "23"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂Q.xls",
				arrElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂Q.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\̒ړIȓǂݏ̃eXg
	 * ɃR[hJԂP[X
	 * Listɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly3() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectly3");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂R.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂R.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\̒ړIȓǂݏ̃eXg
	 * ɃR[hJԂP[X
	 * zɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly4() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectly4");
		XMLTestElement[] arrElm = (XMLTestElement[]) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		XMLTestElement elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"90", "56", "81", "23"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂S.xls",
				arrElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂S.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\i}bvj̒ړIȓǂݏ̃eXg
	 * ɃR[hJԂP[X
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectlyMappedCell() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectlyMappedCell");
		@SuppressWarnings("unchecked")
		Map<String, String> mappedCell = (Map<String, String>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, mappedCell.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, mappedCell.keySet().size());

		String[] keys = new String[]{"L[P", "L[Q", "L[R", "L[S"};
		String[] values = new String[]{"lP", "lQ", "lR", "lS"};
		int i = 0;
		for (String key : mappedCell.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], mappedCell.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݁iMappedCellj.xls",
				mappedCell);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݁iMappedCellj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFMappedCellFkey1","L[P", getCellValue(sheet, 41, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","lP",   getCellValue(sheet, 42, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","L[Q", getCellValue(sheet, 41, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","lQ",   getCellValue(sheet, 42, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","L[R", getCellValue(sheet, 41, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","lR",   getCellValue(sheet, 42, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","L[S", getCellValue(sheet, 41, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","lS",   getCellValue(sheet, 42, 6, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\i}bvj̒ړIȓǂݏ̃eXg
	 * cɃR[hJԂP[X
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectlyMappedCellVertical() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectlyMappedCellVertical");
		@SuppressWarnings("unchecked")
		Map<String, String> countMembersMap = (Map<String, String>) bridge.load("./files/upload/ParserTest.xls", "Users2");

		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"Users2",
				"./files/export/XMLParserTest_ڕ\ǂݍ݁iMappedCellFHorisontalj.xls",
				countMembersMap);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݁iMappedCellFHorisontalj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("Users2");

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 36, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 36, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 37, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 37, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 38, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 38, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 39, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 39, 3, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂV[gw̃eXg
	 *
	 */
	@Test
	public void testReadAndSaveSpecifySheetNameAtXML() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveSpecifySheetNameAtXML");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_V[gw.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_V[gw.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̈ʒuɁAʒuipositionjw肵ۂ̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveTableSpecifiedByPosition() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableSpecifiedByPosition");
		XMLTestElement[] arrElm = (XMLTestElement[]) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFArray", XMLTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		XMLTestElement elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"90", "56", "81", "23"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_\ʒuwǂݍ.xls",
				arrElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_\ʒuwǂݍ.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̓ǂݍ݂ɏI[iterminatejwsȂꍇ̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveTableNoSpacifiedTerminate() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableNoSpacifiedTerminate");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 6, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(4);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 5, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 155.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"400", "270", "240", "200"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(5);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 6, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "k", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "q", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 158.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N619", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"184", "197", "182", "178"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 98, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 98, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 98, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 98, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 98, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 98, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 97, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 97, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 97, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 97, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 98, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 98, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 98, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 98, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 99, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 99, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 99, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 99, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 99, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 99, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 99, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 99, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 99, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 99, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 100, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 100, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 100, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 100, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 100, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 100, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 100, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 100, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 100, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 100, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 101, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 101, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 101, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 101, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 101, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 101, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 101, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 101, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 101, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 101, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 5, getCellValue(sheet, 102, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 102, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 102, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 102, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 155.5, (Double)getCellValue(sheet, 102, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 102, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","400", getCellValue(sheet, 102, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","270", getCellValue(sheet, 102, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","240", getCellValue(sheet, 102, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","200", getCellValue(sheet, 102, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 6, getCellValue(sheet, 103, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "k", getCellValue(sheet, 103, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "q", getCellValue(sheet, 103, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 103, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 158.0, (Double)getCellValue(sheet, 103, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N619", getCellValue(sheet, 103, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","184", getCellValue(sheet, 103, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","197", getCellValue(sheet, 103, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","182", getCellValue(sheet, 103, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","178", getCellValue(sheet, 103, 15, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̓ǂݍ݂ɕK{wiuse=requiredjw肵ۂ̓eXg
	 * K{Y\Ȃꍇ˗O
	 */
	@SuppressWarnings("unchecked")
	@Test(expected=CellNotFoundException.class)
	public void testReadAndSaveTableUseRequired() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableUseRequired");
		@SuppressWarnings("unused")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * \̓ǂݍ݂ɔCӎwiuse=optionaljw肵ۂ̓eXg
	 * Y\Ȃꍇˋ̎w肳ꂽXgԂ
	 */
	@Test
	public void testReadAndSaveTableUseOptional() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableUseOptional");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 0, listElm.size());

	}

	/**
	 * \̓ǂݍ݂ɕK{ / Cӂ̎wsȂۂ̓eXg
	 * Y\Ȃꍇuse=optionalƓi̎w肳ꂽXgԂj
	 */
	@Test
	public void testReadAndSaveTableUseNone() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableUseNone.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableUseNone> listElm = (List<AnnotationTestElementReadTableUseNone>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 0, listElm.size());

	}


	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * \ŜɎwic̕\j̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByVerticalRepeats() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableMargedRowsSpacifiedByVerticalRepeats");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_l̏ȗiځj.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_l̏ȗiځj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * \ŜɎwic̕\j̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByHorizontalRepeats() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableMargedRowsSpacifiedByHorizontalRepeats");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂R.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂R.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 58, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * xƂɎw̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByLabel() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableMargedRowsSpacifiedByLabel");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_l̏ȗiځj.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_l̏ȗiځj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * wȂ̃P[X 󗓂͋󗓂̂܂
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedNone() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableMargedRowsSpacifiedNone");
		@SuppressWarnings("unchecked")
		List<XMLTestElement> listElm = (List<XMLTestElement>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		XMLTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_l̏ȗiځj.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_l̏ȗiځj.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * eNXlpwisucceedFieldsj̊mF
	 *
	 * @throws ExcelPOJOException
	 * @throws IOException
	 */
	@Test
	public void testSucceedFields() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/TableDef.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("TableDefMember");

		TableInfo targetBean = (TableInfo) bridge.load("./files/upload/e[u`_}X^.xls");

		assertEquals("{i擾jFLabeledCell", "MEMBER", targetBean.getTableName());
		assertEquals("{i擾jFLabeledCell", "}X^", targetBean.getTableNameKnj());
		assertEquals("{i擾jFLabeledCell", "T", targetBean.getTableType());

		String today = (new SimpleDateFormat("yyyyMMdd")).format(new Date());
		assertEquals("{i擾jFConstantValue", today, targetBean.getComcrtYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", targetBean.getComcrtShainCod());
		assertEquals("{i擾jFConstantValue", today, targetBean.getComupdYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", targetBean.getComupdShainCod());

		TreeMap<String, ColumnInfo> columnMap = targetBean.getColumnMap();
		assertEquals("{i擾jFVerticalRepeatsFMap", TreeMap.class, columnMap.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 3, columnMap.keySet().size());

		ColumnInfo elm = columnMap.get("1");
		assertEquals("{i擾jFVerticalRepeats(Element)", "MEMBER", elm.getTableName());
		assertEquals("{i擾jFVerticalRepeats(Element)", 1, elm.getColumnId());
		assertEquals("{i擾jFVerticalRepeats(Element)", "MEMBER_CODE", elm.getColumnName());
		assertEquals("{i擾jFVerticalRepeats(Element)", "R[h", elm.getColumnNameKnj());
		assertEquals("{i擾jFVerticalRepeats(Element)", "varchar", elm.getColumnAttr());
		assertEquals("{i擾jFVerticalRepeats(Element)", 11, elm.getColumnLength());
		assertEquals("{i擾jFVerticalRepeats(Element)", 0, elm.getFloatingPos());
		assertEquals("{i擾jFVerticalRepeats(Element)", 1, elm.getPrimaryKeyNo());
		assertEquals("{i擾jFVerticalRepeats(Element)", "N", elm.getNullable());
		assertEquals("{i擾jFVerticalRepeats(Element)", "", elm.getInitialValue());
		assertEquals("{i擾jFConstantValue", today, elm.getComcrtYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComcrtShainCod());
		assertEquals("{i擾jFConstantValue", today, elm.getComupdYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComupdShainCod());

		elm = columnMap.get("2");
		assertEquals("{i擾jFVerticalRepeats(Element)", "MEMBER", elm.getTableName());
		assertEquals("{i擾jFVerticalRepeats(Element)", 2, elm.getColumnId());
		assertEquals("{i擾jFVerticalRepeats(Element)", "MEMBER_NAME", elm.getColumnName());
		assertEquals("{i擾jFVerticalRepeats(Element)", "", elm.getColumnNameKnj());
		assertEquals("{i擾jFVerticalRepeats(Element)", "varchar", elm.getColumnAttr());
		assertEquals("{i擾jFVerticalRepeats(Element)", 256, elm.getColumnLength());
		assertEquals("{i擾jFVerticalRepeats(Element)", 0, elm.getFloatingPos());
		assertEquals("{i擾jFVerticalRepeats(Element)", 0, elm.getPrimaryKeyNo());
		assertEquals("{i擾jFVerticalRepeats(Element)", "N", elm.getNullable());
		assertEquals("{i擾jFVerticalRepeats(Element)", "", elm.getInitialValue());
		assertEquals("{i擾jFConstantValue", today, elm.getComcrtYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComcrtShainCod());
		assertEquals("{i擾jFConstantValue", today, elm.getComupdYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComupdShainCod());

		elm = columnMap.get("3");
		assertEquals("{i擾jFVerticalRepeats(Element)", "MEMBER", elm.getTableName());
		assertEquals("{i擾jFVerticalRepeats(Element)", 3, elm.getColumnId());
		assertEquals("{i擾jFVerticalRepeats(Element)", "MAIL_ADDR", elm.getColumnName());
		assertEquals("{i擾jFVerticalRepeats(Element)", "[AhX", elm.getColumnNameKnj());
		assertEquals("{i擾jFVerticalRepeats(Element)", "varchar", elm.getColumnAttr());
		assertEquals("{i擾jFVerticalRepeats(Element)", 256, elm.getColumnLength());
		assertEquals("{i擾jFVerticalRepeats(Element)", 0, elm.getFloatingPos());
		assertEquals("{i擾jFVerticalRepeats(Element)", 0, elm.getPrimaryKeyNo());
		assertEquals("{i擾jFVerticalRepeats(Element)", "N", elm.getNullable());
		assertEquals("{i擾jFVerticalRepeats(Element)", "", elm.getInitialValue());
		assertEquals("{i擾jFConstantValue", today, elm.getComcrtYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComcrtShainCod());
		assertEquals("{i擾jFConstantValue", today, elm.getComupdYMD());
		assertEquals("{i擾jFConstantValue", "SYS0000", elm.getComupdShainCod());

		bridge.save(
				"./files/template/e[u`_Template.xls",
				"e[u݌v",
				"./files/export/XML_lpmF.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XML_lpmF.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("e[u݌v");

			assertEquals("{i݁jFVerticalRepeats(Element)", "}X^", getCellValue(sheet, 5, 1, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "MEMBER", getCellValue(sheet, 5, 11, CELL_TYPE_STRING));

			assertEquals("{i݁jFVerticalRepeats(Element)", 1, getCellValue(sheet, 8, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "R[h", getCellValue(sheet, 8, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "MEMBER_CODE", getCellValue(sheet, 8, 13, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "varchar", getCellValue(sheet, 8, 23, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", 11, getCellValue(sheet, 8, 27, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 0, getCellValue(sheet, 8, 29, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 1, getCellValue(sheet, 8, 31, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "N", getCellValue(sheet, 8, 33, CELL_TYPE_STRING));

			assertEquals("{i݁jFVerticalRepeats(Element)", 2, getCellValue(sheet, 9, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "", getCellValue(sheet, 9, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "MEMBER_NAME", getCellValue(sheet, 9, 13, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "varchar", getCellValue(sheet, 9, 23, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", 256, getCellValue(sheet, 9, 27, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 0, getCellValue(sheet, 9, 29, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 0, getCellValue(sheet, 9, 31, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "N", getCellValue(sheet, 9, 33, CELL_TYPE_STRING));

			assertEquals("{i݁jFVerticalRepeats(Element)", 3, getCellValue(sheet, 10, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "[AhX", getCellValue(sheet, 10, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "MAIL_ADDR", getCellValue(sheet, 10, 13, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", "varchar", getCellValue(sheet, 10, 23, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)", 256, getCellValue(sheet, 10, 27, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 0, getCellValue(sheet, 10, 29, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", 0, getCellValue(sheet, 10, 31, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)", "N", getCellValue(sheet, 10, 33, CELL_TYPE_STRING));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML̒`ɂ鏑݂̃eXg
	 * ǂݍ݂s킸ڏ݂sꍇ̊mF
	 *
	 */
	@Test
	public void testSaveDirectly() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveBasic");

		XMLTest targetBean = new XMLTest();
		targetBean.setStringField4LabeledCell1("P");
		targetBean.setIntField4LabeledCell1(45);
		targetBean.setBooleanField4LabeledCell1(true);
		targetBean.setDoubleField4LabeledCell1(78.56);
		targetBean.setDateField4LabeledCell1("2010/06/18");

		targetBean.setStringField4PointedCell1("ʒuɂ錟F");
		targetBean.setIntField4PointedCell1(234);
		targetBean.setBooleanField4PointedCell1(false);
		targetBean.setDoubleField4PointedCell1(963.2);
		targetBean.setDateField4PointedCell1("2010/06/22");

		targetBean.setStringField4ConstantValue1("ŒlF");
		targetBean.setIntField4ConstantValue1(258);
		targetBean.setBooleanField4ConstantValue1(false);
		targetBean.setDoubleField4ConstantValue1(3.14);


		Map<String, String> countMembersMap = new LinkedHashMap<String, String>();
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		for (int i = 0; i < 4; i++) {
			countMembersMap.put(keys[i], values[i]);
		}
		targetBean.setMapField4MappedCell1(countMembersMap);

		List<XMLTestElement> listElm = new ArrayList<XMLTestElement>();
		targetBean.setList4VerticalRepeats1(listElm);

		XMLTestElement elm1 = new XMLTestElement();
		elm1.setId(1);
		elm1.setFirstName("c");
		elm1.setLastName("M");
		elm1.setPremiumMember(false);
		elm1.setTall(175.5);
		elm1.setAdmissionDay("2010N611");

		Map<String, String> useTimeMap1 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		for (int i = 0; i < 4; i++) {
			useTimeMap1.put(keys[i], values[i]);
		}
		elm1.setUseTimeMap(useTimeMap1);
		listElm.add(elm1);

		XMLTestElement elm2 = new XMLTestElement();
		elm2.setId(2);
		elm2.setFirstName("Dc");
		elm2.setLastName("M");
		elm2.setPremiumMember(true);
		elm2.setTall(178.5);
		elm2.setAdmissionDay("2010N620");

		Map<String, String> useTimeMap2 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		for (int i = 0; i < 4; i++) {
			useTimeMap2.put(keys[i], values[i]);
		}
		elm2.setUseTimeMap(useTimeMap2);
		listElm.add(elm2);

		XMLTestElement elm3 = new XMLTestElement();
		elm3.setId(3);
		elm3.setFirstName("");
		elm3.setLastName("ƍN");
		elm3.setPremiumMember(false);
		elm3.setTall(165.0);
		elm3.setAdmissionDay("2010N618");

		Map<String, String> useTimeMap3 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		for (int i = 0; i < 4; i++) {
			useTimeMap3.put(keys[i], values[i]);
		}
		elm3.setUseTimeMap(useTimeMap3);
		listElm.add(elm3);

		XMLTestElement elm4 = new XMLTestElement();
		elm4.setId(4);
		elm4.setFirstName("א");
		elm4.setLastName("KV");
		elm4.setPremiumMember(false);
		elm4.setTall(160.0);
		elm4.setAdmissionDay("2010N622");

		Map<String, String> useTimeMap4 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		for (int i = 0; i < 4; i++) {
			useTimeMap4.put(keys[i], values[i]);
		}
		elm4.setUseTimeMap(useTimeMap4);
		listElm.add(elm4);



		XMLTestElement[] arrElm = new XMLTestElement[2];
		targetBean.setArr4VerticalRepeats1(arrElm);

		XMLTestElement elm5 = new XMLTestElement();
		elm5.setId(1);
		elm5.setFirstName("");
		elm5.setLastName("܂");
		elm5.setPremiumMember(true);
		elm5.setTall(156.0);
		elm5.setAdmissionDay("2010N615");

		Map<String, String> useTimeMap5 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		for (int i = 0; i < 4; i++) {
			useTimeMap5.put(keys[i], values[i]);
		}
		elm5.setUseTimeMap(useTimeMap5);
		arrElm[0] = elm5;

		XMLTestElement elm6 = new XMLTestElement();
		elm6.setId(2);
		elm6.setFirstName("");
		elm6.setLastName("");
		elm6.setPremiumMember(false);
		elm6.setTall(168.5);
		elm6.setAdmissionDay("2010N617");

		Map<String, String> useTimeMap6 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		for (int i = 0; i < 4; i++) {
			useTimeMap6.put(keys[i], values[i]);
		}
		elm6.setUseTimeMap(useTimeMap6);
		arrElm[1] = elm6;


		List<XMLTestElement> listElmH = new ArrayList<XMLTestElement>();
		targetBean.setList4HorizontalRepeats1(listElmH);

		XMLTestElement elm7 = new XMLTestElement();
		elm7.setId(1);
		elm7.setFirstName("cH");
		elm7.setLastName("MH");
		elm7.setPremiumMember(false);
		elm7.setTall(175.5);
		elm7.setAdmissionDay("2010N611");

		Map<String, String> useTimeMap7 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		for (int i = 0; i < 4; i++) {
			useTimeMap7.put(keys[i], values[i]);
		}
		elm7.setUseTimeMap(useTimeMap7);
		listElmH.add(elm7);

		XMLTestElement elm8 = new XMLTestElement();
		elm8.setId(2);
		elm8.setFirstName("DcH");
		elm8.setLastName("MH");
		elm8.setPremiumMember(true);
		elm8.setTall(178.5);
		elm8.setAdmissionDay("2010N620");

		Map<String, String> useTimeMap8 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		for (int i = 0; i < 4; i++) {
			useTimeMap8.put(keys[i], values[i]);
		}
		elm8.setUseTimeMap(useTimeMap8);
		listElmH.add(elm8);

		XMLTestElement elm9 = new XMLTestElement();
		elm9.setId(3);
		elm9.setFirstName("H");
		elm9.setLastName("ƍNH");
		elm9.setPremiumMember(false);
		elm9.setTall(165.0);
		elm9.setAdmissionDay("2010N618");

		Map<String, String> useTimeMap9 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		for (int i = 0; i < 4; i++) {
			useTimeMap9.put(keys[i], values[i]);
		}
		elm9.setUseTimeMap(useTimeMap9);
		listElmH.add(elm9);

		XMLTestElement elm10 = new XMLTestElement();
		elm10.setId(4);
		elm10.setFirstName("אH");
		elm10.setLastName("KVH");
		elm10.setPremiumMember(false);
		elm10.setTall(160.0);
		elm10.setAdmissionDay("2010N622");

		Map<String, String> useTimeMap10 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		for (int i = 0; i < 4; i++) {
			useTimeMap10.put(keys[i], values[i]);
		}
		elm10.setUseTimeMap(useTimeMap10);
		listElmH.add(elm10);

		XMLTestElement[] arrElmH = new XMLTestElement[2];
		targetBean.setArr4HorizontalRepeats1(arrElmH);

		XMLTestElement elm11 = new XMLTestElement();
		elm11.setId(1);
		elm11.setFirstName("H");
		elm11.setLastName("܂H");
		elm11.setPremiumMember(true);
		elm11.setTall(156.0);
		elm11.setAdmissionDay("2010N615");

		Map<String, String> useTimeMap11 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		for (int i = 0; i < 4; i++) {
			useTimeMap11.put(keys[i], values[i]);
		}
		elm11.setUseTimeMap(useTimeMap11);
		arrElmH[0] = elm11;

		XMLTestElement elm12 = new XMLTestElement();
		elm12.setId(2);
		elm12.setFirstName("H");
		elm12.setLastName("H");
		elm12.setPremiumMember(false);
		elm12.setTall(168.5);
		elm12.setAdmissionDay("2010N617");

		Map<String, String> useTimeMap12 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		for (int i = 0; i < 4; i++) {
			useTimeMap12.put(keys[i], values[i]);
		}
		elm12.setUseTimeMap(useTimeMap12);
		arrElmH[1] = elm12;

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڏ.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڏ.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 77, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 81, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 78, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 87, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 79, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 89, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 91, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 92, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 89, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 90, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 91, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 92, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 77, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 80, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 81, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 78, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 87, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 79, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 89, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 90, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 91, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 92, 4, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XML`ɂ\̒ړIȏ݂̃eXg
	 * cɃR[hJԂP[X
	 * Listɂ擾
	 *
	 */
	@Test
	public void testSaveTableDirectly1() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testReadAndSaveTableDirectly1");

		List<XMLTestElement> listElm = new ArrayList<XMLTestElement>();

		XMLTestElement elm1 = new XMLTestElement();
		elm1.setId(1);
		elm1.setFirstName("c");
		elm1.setLastName("M");
		elm1.setPremiumMember(false);
		elm1.setTall(175.5);
		elm1.setAdmissionDay("2010N611");

		Map<String, String> useTimeMap1 = new LinkedHashMap<String, String>();
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		for (int i = 0; i < 4; i++) {
			useTimeMap1.put(keys[i], values[i]);
		}
		elm1.setUseTimeMap(useTimeMap1);
		listElm.add(elm1);

		XMLTestElement elm2 = new XMLTestElement();
		elm2.setId(2);
		elm2.setFirstName("Dc");
		elm2.setLastName("M");
		elm2.setPremiumMember(true);
		elm2.setTall(178.5);
		elm2.setAdmissionDay("2010N620");

		Map<String, String> useTimeMap2 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		for (int i = 0; i < 4; i++) {
			useTimeMap2.put(keys[i], values[i]);
		}
		elm2.setUseTimeMap(useTimeMap2);
		listElm.add(elm2);

		XMLTestElement elm3 = new XMLTestElement();
		elm3.setId(3);
		elm3.setFirstName("");
		elm3.setLastName("ƍN");
		elm3.setPremiumMember(false);
		elm3.setTall(165.0);
		elm3.setAdmissionDay("2010N618");

		Map<String, String> useTimeMap3 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		for (int i = 0; i < 4; i++) {
			useTimeMap3.put(keys[i], values[i]);
		}
		elm3.setUseTimeMap(useTimeMap3);
		listElm.add(elm3);

		XMLTestElement elm4 = new XMLTestElement();
		elm4.setId(4);
		elm4.setFirstName("א");
		elm4.setLastName("KV");
		elm4.setPremiumMember(false);
		elm4.setTall(160.0);
		elm4.setAdmissionDay("2010N622");

		Map<String, String> useTimeMap4 = new LinkedHashMap<String, String>();
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		for (int i = 0; i < 4; i++) {
			useTimeMap4.put(keys[i], values[i]);
		}
		elm4.setUseTimeMap(useTimeMap4);
		listElm.add(elm4);

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * ͈͎w茟̃eXg
	 * c̕\ɑ΂w̏ꍇiK{ɂĂ̂Ōsv̏ꍇ͗Oj
	 * @throws ExcelPOJOException
	 */
	@Test(expected=CellNotFoundException.class)
	public void testRangeVerticalRepeats() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testRangeVerticalRepeats");
		@SuppressWarnings("unused")
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * ͈͎w茟̃eXg
	 * ̕\ɑ΂w̏ꍇiK{ɂĂ̂Ōsv̏ꍇ͗Oj
	 * @throws ExcelPOJOException
	 */
	@Test(expected=CellNotFoundException.class)
	public void testRangeHorizontalRepeats() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testRangeHorizontalRepeats");
		@SuppressWarnings("unused")
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * ͈͎w茟̃eXg
	 * MappedCellɑ΂w̏ꍇiK{ɂĂ̂Ōsv̏ꍇ͗Oj
	 * @throws ExcelPOJOException
	 */
	@Test(expected=CellNotFoundException.class)
	public void testRangeMappedCell() throws ExcelPOJOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testRangeMappedCell");
		@SuppressWarnings("unused")
		XMLTest targetBean = (XMLTest) bridge.load("./files/upload/ParserTest.xls", "{");
	}

}
